/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public abstract class TMyPrebufferedFile
extends TMyFile {
    protected int bufferOffset;
    protected int bufferSize;
    protected byte[] buffer;
    protected int FilePos;

    protected void InvalidateBuffer() {
        this.bufferSize = 0;
    }

    protected TMyPrebufferedFile(String string, boolean bl) throws Exception {
        super(string);
        if (bl) {
            hxshared.gc();
            this.buffer = new byte[Runtime.getRuntime().totalMemory() > 300000L ? 4096 : 1024];
        }
        this.InvalidateBuffer();
        this.FilePos = 0;
    }

    public int FilePos() {
        return this.FilePos;
    }

    public void Seek(int n) {
        if (n > this.Length) {
            n = this.Length;
        }
        this.FilePos = n < 0 ? 0 : n;
    }

    protected abstract boolean PreBuffer();

    public int Read(byte[] byArray, int n, int n2) {
        if (this.FilePos + n2 > this.Length) {
            n2 = this.Length - this.FilePos;
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.FilePos >= this.bufferOffset && this.FilePos < this.bufferOffset + this.bufferSize) {
            int n3 = this.bufferOffset + this.bufferSize - this.FilePos;
            if (n3 >= n2) {
                System.arraycopy(this.buffer, this.FilePos - this.bufferOffset, byArray, n, n2);
                this.FilePos += n2;
                return n2;
            }
            System.arraycopy(this.buffer, this.FilePos - this.bufferOffset, byArray, n, n3);
            this.FilePos += n3;
            this.PreBuffer();
            return n3 + this.Read(byArray, n + n3, n2 - n3);
        }
        this.PreBuffer();
        return this.Read(byArray, n, n2);
    }

    public boolean ReadSingleByte(byte[] byArray, int n) {
        if (this.FilePos >= this.Length) {
            return false;
        }
        boolean bl = true;
        if (this.FilePos < this.bufferOffset || this.FilePos >= this.bufferOffset + this.bufferSize) {
            bl = this.PreBuffer();
        }
        byArray[n] = this.buffer[this.FilePos - this.bufferOffset];
        ++this.FilePos;
        return bl;
    }

    public boolean ReadSingleByteReverse(byte[] byArray, int n) {
        if (this.FilePos == 0) {
            return false;
        }
        --this.FilePos;
        boolean bl = true;
        if (this.FilePos < this.bufferOffset || this.FilePos >= this.bufferOffset + this.bufferSize) {
            bl = this.PreBuffer();
        }
        byArray[n] = this.buffer[this.FilePos - this.bufferOffset];
        return bl;
    }

    public byte ReadByte() throws IOException {
        if (this.FilePos >= this.Length) {
            return 0;
        }
        if (this.FilePos < this.bufferOffset || this.FilePos >= this.bufferOffset + this.bufferSize) {
            this.PreBuffer();
        }
        byte by = this.buffer[this.FilePos - this.bufferOffset];
        ++this.FilePos;
        return by;
    }
}

